/*================================================================================
	
	---------------------------------------
	-*- Zombie Plague 4.2 Includes File -*-
	---------------------------------------
	
	~~~~~~~~~~
	- How To -
	~~~~~~~~~~
	
	To use the functions listed here on your plugin, just add the
	following line at the beginning of your script:
	
	#include <zombieplague>
	
	~~~~~~~~~~~
	- Natives -
	~~~~~~~~~~~
	
	These work just like any other functions: you may have to pass
	parameters and they usually return values (1 means true, 0 for
	false).
	
	Example:
	
	if ( is_user_alive(id) && zp_get_user_zombie(id) )
	{
		server_print("player %d is alive and a zombie", id)
	}
	
	~~~~~~~~~~~~
	- Forwards -
	~~~~~~~~~~~~
	
	Forwards get called whenever an event happens during the game.
	You need to make a public function somewhere on your script,
	and it will automatically be triggered at the right time.
	
	Example:
	
	public zp_user_infected_post(id, infector)
	{
		server_print("Player %d just got infected by %d!", id, infector)
	}
	
	Also, take note of cases when there's a suffix:
	
	* _pre  : means the forward will be called BEFORE the event happens
	* _post : means it will be called AFTER the event takes place
	
=================================================================================*/

#if defined _zombieplague_included
  #endinput
#endif
#define _zombieplague_included

/* Returns whether a player is a zombie */
native zp_get_user_zombie(id)

/* Returns whether a player is a nemesis */
native zp_get_user_nemesis(id)

/* Returns whether a player is a survivor */
native zp_get_user_survivor(id)

/* Returns whether a player is the first zombie */
native zp_get_user_first_zombie(id)

/* Returns whether a player is the last zombie */
native zp_get_user_last_zombie(id)

/* Returns whether a player is the last human */
native zp_get_user_last_human(id)

/* Returns a player's current zombie class ID */
native zp_get_user_zombie_class(id)

/* Sets a player's zombie class ID (for the next infection) */
native zp_set_user_zombie_class(id, classid)

/* Returns a player's ammo pack count */
native zp_get_user_ammo_packs(id)

/* Sets a player's ammo pack count */
native zp_set_user_ammo_packs(id, amount)

/* Returns the default maximum health of a zombie */
native zp_get_zombie_maxhealth(id)

/* Returns a player's custom flashlight batteries charge */
native zp_get_user_batteries(id)

/* Sets a player's custom flashlight batteries charge */
native zp_set_user_batteries(id, value)

/* Forces a player to become a zombie (infection rounds only) */
native zp_infect_user(id, infector = 0)

/* Forces a player to become a human (infection rounds only) */
native zp_disinfect_user(id)

/* Respawns a player to a specific team (infections rounds only) */
native zp_respawn_user(id, team)

/* Returns whether the round has started (i.e. a game mode began) */
native zp_has_round_started()

/* Returns whether it's a nemesis round */
native zp_is_nemesis_round()

/* Returns whether it's a survivor round */
native zp_is_survivor_round()

/* Returns whether it's a swarm round */
native zp_is_swarm_round()

/* Returns whether it's a plague round */
native zp_is_plague_round()

/* Teams for zp_register_extra_item() */
enum
{
	ZP_TEAM_ANY = 0,
	ZP_TEAM_ZOMBIE,
	ZP_TEAM_HUMAN
}

/* Registers a custom item which will be added to the extra items menu of ZP.
*  Returns an internal extra item ID (which is needed to correctly catch selection
*  events for the zp_extra_item_selected() forward) or -1 on failure. */
native zp_register_extra_item(const name[], cost, team)

/* Registers a custom class which will be added to the zombie classes menu of ZP.
*  Returns an internal zombie class ID (which is then used to identify the class
*  when calling the zp_get_user_zombie_class() native) or -1 on failure. */
native zp_register_zombie_class(const name[], const info[], const model[], const clawmodel[], hp, speed, Float:gravity, Float:knockback)

/* ============================================================================ */

/* Called when the round starts
*  gamemode - will indicate which mode has commenced
*  player   - will hold the affected player id (if applicable) */
forward zp_round_started(gamemode, player)

/* Game modes for zp_round_started() */
enum
{
	MODE_NONE = 0,
	MODE_INFECTION,
	MODE_NEMESIS,
	MODE_SURVIVOR,
	MODE_SWARM,
	MODE_MULTI,
	MODE_PLAGUE
}

/* Called when the round ends */
forward zp_round_ended(winteam)

/* Winning teams for zp_round_ended() */
enum
{
	WIN_NO_ONE = 0,
	WIN_ZOMBIES,
	WIN_HUMANS
}

/* Called when a player gets infected. */
forward zp_user_infected_pre(id, infector)
forward zp_user_infected_post(id, infector)

/* Called when a player turns back to human */
forward zp_user_humanized_pre(id)
forward zp_user_humanized_post(id)

/* Called when a player buys an extra item from the ZP menu
*  player - will hold the id of the player who's buying
*  itemid - will contain the internal extra item ID */
forward zp_extra_item_selected(player, itemid)
