#include <amxmodx>
#include <engine>
#include <fakemeta>
#include <fun>
#include <hamsandwich>
#include <xs>
#include <cstrike>
#include <zombieplague>
#include <ham_const>

#pragma tabsize 0
			
new const Fire_Sounds[][] = { "weapons/scar_shoot1.wav" }

new const GUNSHOT_DECALS[] = { 41, 42, 43, 44, 45 }

new scar_V_MODEL[64] = "models/v_scar.mdl"
new scar_P_MODEL[64] = "models/p_scar.mdl"
new scar_W_MODEL[64] = "models/w_scar.mdl"

new cvar_dmg_scar, cvar_recoil_scar, cvar_recoil_scar2, cvar_clip_scar2, cvar_scar_ammo , cvar_dmg_scar2 , cvar_spd_1mode , cvar_spd_2mode , cvar_clip_scar1
new g_has_scar[33] , g_line[33]
new g_orig_event_scar, g_clip_ammo[33] , g_reload[33]
new Float:cl_pushangle[33][3], m_iBlood[2]
new g_scar_TmpClip[33]
new g_mode[33], g_change[33]
new g_itemid_scar
new oldweap[33]

const PRIMARY_WEAPONS_BIT_SUM = 
(1<<CSW_SCOUT)|(1<<CSW_XM1014)|(1<<CSW_MAC10)|(1<<CSW_AUG)|(1<<CSW_UMP45)|(1<<CSW_SG550)|(1<<CSW_GALIL)|(1<<CSW_FAMAS)|(1<<CSW_AWP)|(1<<
CSW_MP5NAVY)|(1<<CSW_M249)|(1<<CSW_M3)|(1<<CSW_M4A1)|(1<<CSW_TMP)|(1<<CSW_G3SG1)|(1<<CSW_SG552)|(1<<CSW_AK47)|(1<<CSW_P90)


public plugin_init()
{
	register_plugin("[ZP] Extra Item: Scar", "1.0", "Crock")
	register_message(get_user_msgid("DeathMsg"), "message_DeathMsg")
	register_event("CurWeapon","CurrentWeapon","be","1=1")
	
	RegisterHam(Ham_Item_AddToPlayer, "weapon_aug", "fw_scar_AddToPlayer")
	RegisterHam(Ham_Item_Deploy, "weapon_aug", "fw_Item_Deploy_Post", 1)
	RegisterHam(Ham_Weapon_PrimaryAttack, "weapon_aug", "fw_scar_PrimaryAttack")
	RegisterHam(Ham_Weapon_PrimaryAttack, "weapon_aug", "fw_scar_PrimaryAttack_Post", 1)
	RegisterHam(Ham_Weapon_SecondaryAttack, "weapon_aug", "fw_scar_SecondaryAttack") 
	RegisterHam(Ham_Item_PostFrame, "weapon_aug", "scar__ItemPostFrame");
	RegisterHam(Ham_Weapon_Reload, "weapon_aug", "scar__Reload");
	RegisterHam(Ham_Weapon_Reload, "weapon_aug", "scar__Reload_Post", 1);
	RegisterHam(Ham_CS_Weapon_SendWeaponAnim, "weapon_aug", "fw_cart_SendWeaponAnim_Post", 1)
	
	RegisterHam(Ham_TraceAttack, "worldspawn", "fw_TraceAttack", 1)
	RegisterHam(Ham_TraceAttack, "func_breakable", "fw_TraceAttack", 1)
	RegisterHam(Ham_TraceAttack, "func_wall", "fw_TraceAttack", 1)
	RegisterHam(Ham_TraceAttack, "func_door", "fw_TraceAttack", 1)
	RegisterHam(Ham_TraceAttack, "func_door_rotating", "fw_TraceAttack", 1)
	RegisterHam(Ham_TraceAttack, "func_plat", "fw_TraceAttack", 1)
	RegisterHam(Ham_TraceAttack, "func_rotating", "fw_TraceAttack", 1)
	
	register_forward(FM_CmdStart, "fw_CmdStart")
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage")
	register_forward(FM_SetModel, "fw_SetModel")
	register_forward(FM_UpdateClientData, "fw_UpdateClientData_Post", 1)
	register_forward(FM_PlaybackEvent, "fwPlaybackEvent")

	cvar_dmg_scar = register_cvar("scar_dmg", "1.6")
	cvar_dmg_scar2 = register_cvar("scar_dmg_2", "3.2")
	
	cvar_spd_1mode = register_cvar("scar_spd_1mode", "1.0")
	cvar_spd_2mode = register_cvar("scar_spd_2mode", "2.5")
	
	cvar_recoil_scar = register_cvar("scar_recoil", "1.0")
	cvar_recoil_scar2 = register_cvar("scar_recoil_2", "0.8")
		
	cvar_clip_scar1 = register_cvar("scar_clip", "30")
	cvar_clip_scar2 = register_cvar("scar_clip2", "20")
	cvar_scar_ammo = register_cvar("scar_ammo", "180")
	
	g_itemid_scar =  zp_register_extra_item("FN Scar", 45, ZP_TEAM_HUMAN)

}

public plugin_precache()
{
	precache_model(scar_V_MODEL)
	precache_model(scar_P_MODEL)
	precache_model(scar_W_MODEL)
	precache_sound(Fire_Sounds[0])
	precache_sound("weapons/scar_clipin.wav")
	precache_sound("weapons/scar_draw.wav")
	precache_sound("weapons/scar_clipout.wav")
	precache_sound("weapons/scar_change1.wav")
	precache_sound("weapons/scar_change2.wav")
	precache_sound("weapons/scar_change3.wav")
	m_iBlood[0] = precache_model("sprites/blood.spr")
	m_iBlood[1] = precache_model("sprites/bloodspray.spr")
	register_forward(FM_PrecacheEvent, "fwPrecacheEvent_Post", 1)
	precache_generic("sprites/cso/640hud21.spr")
    precache_generic("sprites/cso/640hud22.spr")
	precache_generic("sprites/cso/640hud27.spr")
    precache_generic("sprites/cso/640hud7.spr")	
	precache_generic("sprites/weapon_scarc.txt")
	precache_generic("sprites/weapon_scarh.txt")
	register_clcmd("weapon_scarc", "weapon_hook")
	register_clcmd("weapon_scarh", "weapon_hook")
}

public weapon_hook(id)
{
engclient_cmd(id, "weapon_aug")
}

public zp_extra_item_selected(id, itemid)
{
	if(itemid == g_itemid_scar)
	{	
		give_scar(id)
	}
}

public fw_cart_SendWeaponAnim_Post(ent, anim, skiplocal, body)
{
 if(!pev_valid(ent))
  return

 static id
 id = pev(ent, pev_owner)

 if(!g_has_scar[id] || !g_mode[id] || anim != 0)
  return

 UTIL_PlayWeaponAnimation(id, 6)
}

public fwPrecacheEvent_Post(type, const name[])
{
	if (equal("events/aug.sc", name))
	{
		g_orig_event_scar = get_orig_retval()
		return FMRES_HANDLED
	}
	return FMRES_IGNORED
}

public client_connect(id)
{
	g_has_scar[id] = false
}

public client_disconnect(id)
{
	g_has_scar[id] = false
}

public fw_SetModel(entity, model[])
{
	if(!is_valid_ent(entity))
		return FMRES_IGNORED;
	
	static szClassName[33]
	entity_get_string(entity, EV_SZ_classname, szClassName, charsmax(szClassName))
		
	if(!equal(szClassName, "weaponbox"))
		return FMRES_IGNORED;
	
	static iOwner
	
	iOwner = entity_get_edict(entity, EV_ENT_owner)
	
	if(equal(model, "models/w_aug.mdl"))
	{
		static iStoredSVDID
		
		iStoredSVDID = find_ent_by_owner(-1, "weapon_aug", entity)
	
		if(!is_valid_ent(iStoredSVDID))
			return FMRES_IGNORED;
	
		if(g_has_scar[iOwner])
		{
			entity_set_int(iStoredSVDID, EV_INT_impulse, 914)
			
			g_has_scar[iOwner] = false
			
			g_mode[iOwner] = 0
			
			g_change[iOwner] = 0
			
			entity_set_model(entity, scar_W_MODEL)
			
			return FMRES_SUPERCEDE;
		}
	}
	
	
	return FMRES_IGNORED;
}
public Sprite(id)
{
	message_begin(MSG_ONE, get_user_msgid("WeaponList"), {0,0,0}, id)
        write_string("weapon_scarh")
        write_byte(4)
        write_byte(90)
        write_byte(-1)
        write_byte(-1)
        write_byte(0)
        write_byte(14)
        write_byte(8)
        write_byte(0)
        message_end()
}

public Sprite2mode(id)
{
	message_begin(MSG_ONE, get_user_msgid("WeaponList"), {0,0,0}, id)
        write_string("weapon_scarc")
        write_byte(4)
        write_byte(90)
        write_byte(-1)
        write_byte(-1)
        write_byte(0)
        write_byte(14)
        write_byte(8)
        write_byte(0)
        message_end()
}

public give_scar(id)
{
	drop_weapons(id, 1);
	g_has_scar[id] = true;
	new iWep2 = give_item(id,"weapon_aug")
	if( iWep2 > 0 )
	{
		cs_set_weapon_ammo(iWep2, get_pcvar_num(g_mode[id] ?  cvar_clip_scar2 : cvar_clip_scar1))
		cs_set_user_bpammo (id, CSW_AUG, get_pcvar_num(cvar_scar_ammo))
		Sprite(id)
    }
}

public fw_TraceAttack(iEnt, iAttacker, Float:flDamage, Float:fDir[3], ptr, iDamageType)
{
	if(!is_user_alive(iAttacker))
		return;

	new g_currentweapon = get_user_weapon(iAttacker)
	if(g_currentweapon != CSW_AUG) return
	
	if((g_currentweapon == CSW_AUG && !g_has_scar[iAttacker])) return

	static Float:End[3]
	get_tr2(ptr, TR_vecEndPos, End)
	
	if(iEnt)
	{
		// Put decal on an entity
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_DECAL)
		engfunc(EngFunc_WriteCoord, End[0])  
		engfunc(EngFunc_WriteCoord, End[1]) 
		engfunc(EngFunc_WriteCoord, End[2]) 
		write_byte(random_num(41,45))
		write_short(iEnt)
		message_end()
	}
	else
	{
		// Put decal on "world" (a wall)
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_WORLDDECAL)
		engfunc(EngFunc_WriteCoord, End[0])  
		engfunc(EngFunc_WriteCoord, End[1]) 
		engfunc(EngFunc_WriteCoord, End[2]) 
		write_byte(random_num(41,45))
		message_end()
	}
	
	// Show sparcles
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_GUNSHOTDECAL)
	engfunc(EngFunc_WriteCoord, End[0])  
	engfunc(EngFunc_WriteCoord, End[1])  
	engfunc(EngFunc_WriteCoord, End[2]) 
	write_short(iAttacker)
	write_byte(random_num(41,45))
	message_end()
}

public fw_scar_AddToPlayer(scar, id)
{
	if(!is_valid_ent(scar) || !is_user_connected(id))
		return HAM_IGNORED;
	
	if(entity_get_int(scar, EV_INT_impulse) == 914)
	{
		g_has_scar[id] = true
		Sprite(id)
		
		return HAM_HANDLED;
	}
	
	return HAM_IGNORED;
}

public fw_CmdStart(id, uc_handle, seed)
{
	if(!is_user_alive(id) || get_user_weapon(id) != CSW_AUG || !g_has_scar[id] || g_reload[id] || g_change[id]) 
		return PLUGIN_HANDLED
	
	if((get_uc(uc_handle, UC_Buttons) & IN_USE) && !(pev(id, pev_oldbuttons) & IN_USE))
	{
				if(g_mode[id] == 0)
				make_mode2(id)
				
				if(g_mode[id] == 2)
				make_mode1(id)
	}
	return PLUGIN_HANDLED
}

public make_mode2(id)
{
	remove_task(id)
	set_task(5.8,"mode_new2",id)
	linemode(id);
	g_change[id] = 1
	set_pdata_float(id, 83, 5.8, 5)
	UTIL_PlayWeaponAnimation(id, 5)
}

public make_mode1(id)
{
	remove_task(id)
	set_task(5.8,"mode_new1",id)
	linemode(id);
	g_change[id] = 1
	set_pdata_float(id, 83, 5.8, 5)
	UTIL_PlayWeaponAnimation(id, 11)
}

public mode_new2(id)
{
	if(g_change[id] == 1 && is_user_alive(id))
	{
		g_change[id] = 0
		g_mode[id] = 2
		Sprite2mode(id)
		UTIL_PlayWeaponAnimation(id, 6)
		client_print(id,print_center,"Режим: Снайпер")
	}
}

public mode_new1(id)
{
	if(g_change[id] == 1  && is_user_alive(id))
	{
		g_change[id] = 0
		g_mode[id] = 0
		Sprite(id)
		UTIL_PlayWeaponAnimation(id, 0)
		client_print(id,print_center,"Режим: Автомат")
	}
}

public fw_Item_Deploy_Post(weapon_ent)
{
	static owner
	owner = fm_cs_get_weapon_ent_owner(weapon_ent)
	
	static weaponid
	weaponid = cs_get_weapon_id(weapon_ent)
	
	replace_weapon_models(owner, weaponid)
}

public linemode(id)
{
	g_line[id] = true;

	message_begin(MSG_ONE, 108, {0,0,0}, id);
	write_byte(4);
	write_byte(0);
	message_end();

	return PLUGIN_HANDLED;
}

public CurrentWeapon(id)
{
	replace_weapon_models(id, read_data(2))
	g_reload[id] = 0
	g_change[id] = 0
	
	if(read_data(2) != CSW_AUG || !g_has_scar[id])
	return

     
	if(g_mode[id] == 0 && g_has_scar[id])
    {     
     static Float:iSpeed
     iSpeed = get_pcvar_float(cvar_spd_1mode)
     
     static weapon[32],Ent
     get_weaponname(read_data(2),weapon,31)
     Ent = find_ent_by_owner(-1,weapon,id)
     if(Ent)
    {
          static Float:Delay
          Delay = get_pdata_float( Ent, 46, 4) * iSpeed
          if (Delay > 0.0)
          {
               set_pdata_float(Ent, 46, Delay, 4)
          }
    }
    }
	else
    if(g_mode[id] == 2 && g_has_scar[id])
    {     
     static Float:iSpeed
     iSpeed = get_pcvar_float(cvar_spd_2mode)
     
     static weapon[32],Ent
     get_weaponname(read_data(2),weapon,31)
     Ent = find_ent_by_owner(-1,weapon,id)
     if(Ent)
    {
          static Float:Delay
          Delay = get_pdata_float( Ent, 46, 4) * iSpeed
          if (Delay > 0.0)
          {
               set_pdata_float(Ent, 46, Delay, 4)
          }
    }
    }
}

replace_weapon_models(id, weaponid)
{
	switch (weaponid)
	{
		case CSW_AUG:
		{
			if(g_has_scar[id])
			{
				set_pev(id, pev_weaponmodel2, scar_P_MODEL)
				set_pev(id, pev_viewmodel2, scar_V_MODEL)
				if(oldweap[id] != CSW_AUG)
				{
                    if(g_mode[id] == 0)			
		            UTIL_PlayWeaponAnimation(id, 2)
		            else if(g_mode[id] == 2)
		            UTIL_PlayWeaponAnimation(id, 8)
				}	
		    }
	    }
    }
	oldweap[id] = weaponid 
}

public fw_UpdateClientData_Post(Player, SendWeapons, CD_Handle)
{
        if(!is_user_alive(Player) || (get_user_weapon(Player) != CSW_AUG) || !g_has_scar[Player])
        return FMRES_IGNORED
	
	set_cd(CD_Handle, CD_flNextAttack, halflife_time () + 0.001)
	return FMRES_HANDLED
}

public fw_scar_SecondaryAttack(weapon) 
{ 
	new id = get_pdata_cbase(weapon, 41, 4)

	if(!is_user_alive(id) || !g_has_scar[id] || g_mode[id] == 2)
		return HAM_IGNORED;

	set_pdata_float(weapon, 47, 30.0, 4) 
	return HAM_SUPERCEDE;
} 

public fw_scar_PrimaryAttack(Weapon)
{
	new Player = get_pdata_cbase(Weapon, 41, 4)
	
	if (!g_has_scar[Player])
		return;
	
	pev(Player,pev_punchangle,cl_pushangle[Player])
	
	g_clip_ammo[Player] = cs_get_weapon_ammo(Weapon)
}

public fwPlaybackEvent(flags, invoker, eventid, Float:delay, Float:origin[3], Float:angles[3], Float:fparam1, Float:fparam2, iParam1, iParam2, bParam1, bParam2)
{
	if ((eventid != g_orig_event_scar) || !(1 <= invoker <= get_maxplayers()))
		return FMRES_IGNORED;

	playback_event(flags | FEV_HOSTONLY, invoker, eventid, delay, origin, angles, fparam1, fparam2, iParam1, iParam2, bParam1, bParam2)
	return FMRES_SUPERCEDE
}

public fw_scar_PrimaryAttack_Post(Weapon)
{
	new Player = get_pdata_cbase(Weapon, 41, 4)
	
	new szClip, szAmmo
	get_user_weapon(Player, szClip, szAmmo)
	
	if(g_has_scar[Player])
	{
		static Float:rcl
	
		if(g_mode[Player] == 2)
			rcl = get_pcvar_float(cvar_recoil_scar2)
		else if(!g_mode[Player])
			rcl = get_pcvar_float(cvar_recoil_scar)
		
		new Float:push[3]
		pev(Player,pev_punchangle,push)
		xs_vec_sub(push,cl_pushangle[Player],push)
		
		xs_vec_mul_scalar(push,rcl,push)
		
		xs_vec_add(push,cl_pushangle[Player],push)
		set_pev(Player,pev_punchangle,push)
		
		if (!g_clip_ammo[Player])
			return
		
		emit_sound(Player, CHAN_WEAPON, Fire_Sounds[0], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		
		if(g_mode[Player] == 0)
		UTIL_PlayWeaponAnimation(Player, random_num(3, 4))
		else if(g_mode[Player] == 2)
		UTIL_PlayWeaponAnimation(Player, random_num(9, 10))
	}
}

public fw_TakeDamage(victim, inflictor, attacker, Float:damage)
{
	if (victim != attacker && is_user_connected(attacker))
	{
		if(get_user_weapon(attacker) == CSW_AUG)
		{
			if(g_has_scar[attacker])
			{
				static Float:dmg
				
				if(g_mode[attacker] == 2)
					dmg = get_pcvar_float(cvar_dmg_scar2)
				else if(!g_mode[attacker])
					dmg = get_pcvar_float(cvar_dmg_scar)
			
				SetHamParamFloat(4, damage * dmg)
			}
		}
	}
}

public message_DeathMsg(msg_id, msg_dest, id)
{
	static szTruncatedWeapon[33], iAttacker, iVictim
	
	get_msg_arg_string(4, szTruncatedWeapon, charsmax(szTruncatedWeapon))
	
	iAttacker = get_msg_arg_int(1)
	iVictim = get_msg_arg_int(2)
	
	if(!is_user_connected(iAttacker) || iAttacker == iVictim)
		return PLUGIN_CONTINUE
	
	if(equal(szTruncatedWeapon, "scar") && get_user_weapon(iAttacker) == CSW_AUG)
	{
		if(g_has_scar[iAttacker])
			set_msg_arg_string(4, "scar")
	}
		
	return PLUGIN_CONTINUE
}

stock fm_cs_get_current_weapon_ent(id)
{
	return get_pdata_cbase(id, 373, 5);
}

stock fm_cs_get_weapon_ent_owner(ent)
{
	return get_pdata_cbase(ent, 41, 4);
}

stock UTIL_PlayWeaponAnimation(const Player, const Sequence)
{
	set_pev(Player, pev_weaponanim, Sequence)
	
	message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, .player = Player)
	write_byte(Sequence)
	write_byte(pev(Player, pev_body))
	message_end()
}

stock make_blood_and_bulletholes(id)
{
	new aimOrigin[3], target, body
	get_user_origin(id, aimOrigin, 3)
	get_user_aiming(id, target, body)
	
	if(target > 0 && target <= get_maxplayers())
	{
		new Float:fStart[3], Float:fEnd[3], Float:fRes[3], Float:fVel[3]
		pev(id, pev_origin, fStart)
		
		velocity_by_aim(id, 64, fVel)
		
		fStart[0] = float(aimOrigin[0])
		fStart[1] = float(aimOrigin[1])
		fStart[2] = float(aimOrigin[2])
		fEnd[0] = fStart[0]+fVel[0]
		fEnd[1] = fStart[1]+fVel[1]
		fEnd[2] = fStart[2]+fVel[2]
		
		new res
		engfunc(EngFunc_TraceLine, fStart, fEnd, 0, target, res)
		get_tr2(res, TR_vecEndPos, fRes)
		
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY) 
		write_byte(TE_BLOODSPRITE)
		write_coord(floatround(fStart[0])) 
		write_coord(floatround(fStart[1])) 
		write_coord(floatround(fStart[2])) 
		write_short( m_iBlood [ 1 ])
		write_short( m_iBlood [ 0 ] )
		write_byte(70)
		write_byte(random_num(1,2))
		message_end()
		
		
	} 
	else if(!is_user_connected(target))
	{
		if(target)
		{
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(TE_DECAL)
			write_coord(aimOrigin[0])
			write_coord(aimOrigin[1])
			write_coord(aimOrigin[2])
			write_byte(GUNSHOT_DECALS[random_num ( 0, sizeof GUNSHOT_DECALS -1 ) ] )
			write_short(target)
			message_end()
		} 
		else 
		{
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(TE_WORLDDECAL)
			write_coord(aimOrigin[0])
			write_coord(aimOrigin[1])
			write_coord(aimOrigin[2])
			write_byte(GUNSHOT_DECALS[random_num ( 0, sizeof GUNSHOT_DECALS -1 ) ] )
			message_end()
		}
		
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_GUNSHOTDECAL)
		write_coord(aimOrigin[0])
		write_coord(aimOrigin[1])
		write_coord(aimOrigin[2])
		write_short(id)
		write_byte(GUNSHOT_DECALS[random_num ( 0, sizeof GUNSHOT_DECALS -1 ) ] )
		message_end()
	}
}

public scar__ItemPostFrame(weapon_entity) 
{
	new id = pev(weapon_entity, pev_owner)
	
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_has_scar[id])
		return HAM_IGNORED;

	new Float:flNextAttack = get_pdata_float(id, 83, 5)

	new iBpAmmo = cs_get_user_bpammo(id, CSW_AUG);
	new iClip = get_pdata_int(weapon_entity, 51, 4)

	new fInReload = get_pdata_int(weapon_entity, 54, 4) 

	if( fInReload && flNextAttack <= 0.0 )
	{
		new j = min(get_pcvar_num(g_mode[id] ? cvar_clip_scar2 : cvar_clip_scar1) - iClip, iBpAmmo)
	
		set_pdata_int(weapon_entity, 51, iClip + j, 4)
		cs_set_user_bpammo(id, CSW_AUG, iBpAmmo-j);
		
		set_pdata_int(weapon_entity, 54, 0, 4)
		fInReload = 0
		g_reload[id] = 0
	}

	return HAM_IGNORED;
}

public scar__Reload(weapon_entity) 
{
	new id = pev(weapon_entity, pev_owner)
	
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_has_scar[id])
		return HAM_IGNORED;

	g_scar_TmpClip[id] = -1;

	new iBpAmmo = cs_get_user_bpammo(id, CSW_AUG);
	new iClip = get_pdata_int(weapon_entity, 51, 4)

	if (iBpAmmo <= 0)
		return HAM_SUPERCEDE;

	if (iBpAmmo <= 0 || iClip >= get_pcvar_num(g_mode[id] ?  cvar_clip_scar2 : cvar_clip_scar1))
		return HAM_SUPERCEDE;


	g_scar_TmpClip[id] = iClip;

	g_reload[id] = 1

	return HAM_IGNORED;
}

public scar__Reload_Post(weapon_entity) 
{
	new id = pev(weapon_entity, pev_owner)
	new Player = get_pdata_cbase(weapon_entity, 41, 4)
	
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_has_scar[id])
		return HAM_IGNORED;

	if (g_scar_TmpClip[id] == -1)
		return HAM_IGNORED;

	set_pdata_int(weapon_entity, 51, g_scar_TmpClip[id], 4)

	set_pdata_float(weapon_entity, 48, 3.0, 4)

	set_pdata_float(id, 83, 3.0, 5)

	set_pdata_int(weapon_entity, 54, 1, 4)

	if(g_mode[Player] == 0)
	UTIL_PlayWeaponAnimation(id, 1)
	else if(g_mode[Player] == 2)
	UTIL_PlayWeaponAnimation(id,7)

	return HAM_IGNORED;
}

stock drop_weapons(id, dropwhat)
{
     static weapons[32], num, i, weaponid
     num = 0
     get_user_weapons(id, weapons, num)
     
     for (i = 0; i < num; i++)
     {
          weaponid = weapons[i]
          
          if (dropwhat == 1 && ((1<<weaponid) & PRIMARY_WEAPONS_BIT_SUM))
          {
               static wname[32]
               get_weaponname(weaponid, wname, sizeof wname - 1)
               engclient_cmd(id, "drop", wname)
          }
     }
}
