#include <amxmodx>
#include <engine>
#include <fakemeta_util>
#include <hamsandwich>
#include <zombieplague>
#include <fun>

#define PLUGIN "[CSO:Hunter Zombie]"
#define VERSION "1.2"
#define AUTHOR "HoRRoR/tERoR edit"


// Zombie Attributes
new const zclass_name[] = "Китаец"
new const zclass_info[] = "[ Ускорение ]"
new const zclass_model[] = "china" // model
new const zclass_clawmodel[] = "china.mdl" // claw model
new KNOCKBOMB_CHINA[] = "models/zp/grenade/bomb_china.mdl" //zbomb model
const zclass_health = 2500 // health
const zclass_speed = 245 // speed
const Float:zclass_gravity = 0.88 // gravity
const Float:zclass_knockback =  0.43 // knockback

// --- config ------------------------ //
#define TRAIL_LIFE        2
#define TRAIL_WIDTH       10
#define TRAIL_RED         0
#define TRAIL_GREEN       0
#define TRAIL_BLUE        0
#define TRAIL_BRIGTHNESS  220

new Float:g_fastspeed = 830.0 // sprint speed
new Float:g_normspeed = 245.0 // norm speed. must be as zclass_speed
new Float:g_abilonecooldown = 30.0 // cooldown time
new Float:g_abilonelenght = 3.2 // time of sprint
new const g_china_Infect_Sound[][] =     
{    
    "paradoks_cso/china/infect.wav" , 
    "paradoks_cso/china/infect.wav"  
}  
new const pain_china_sound[] = "paradoks_cso/china/china_pain1.wav" 
new const pain_china_sound2[] = "paradoks_cso/china/china_pain2.wav"
new const death_china_sound[] = "paradoks_cso/china/china_die.wav" //death
new const sound_china_sprint[] = "paradoks_cso/china/china_spd.wav" //sprint sound
// ----------------------------------- //

new i_cooldown_time[33]
new g_zclass_china
new g_speeded[33] = 0
new g_abil_one_used[33] = 0
new gTrail
new g_maxplayers

public plugin_precache()
{
	g_zclass_china = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)	
	precache_sound(sound_china_sprint)
	precache_model(KNOCKBOMB_CHINA)	
	precache_sound(pain_china_sound[0])
	precache_sound(pain_china_sound2[0])
	new i
	for(i = 0 ; i < sizeof g_china_Infect_Sound ; i++) precache_sound(g_china_Infect_Sound[i])
	precache_sound(death_china_sound[0])
}

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_clcmd("drop", "use_ability_one")
	
	register_event("CurWeapon", "Event_CurrentWeapon", "be", "1=1")
	register_forward( FM_PlayerPreThink, "client_prethink" )
	register_logevent("roundStart", 2, "1=Round_Start")
	RegisterHam(Ham_TakeDamage, "player", "CPlayer__TakeDamage");

	register_forward(FM_EmitSound, "fw_EmitSound")
	
	g_maxplayers = get_maxplayers()

	gTrail = engfunc(EngFunc_PrecacheModel,"sprites/paradoks_cso/china_rew.spr")
}


public client_prethink(id)
{
	if (zp_get_user_zombie_class(id) == g_zclass_china)
	{
		if(is_user_alive(id) && zp_get_user_zombie(id) && (zp_get_user_zombie_class(id) == g_zclass_china) && !zp_get_user_nemesis(id))
		Action(id);
	}
}

public Action(id)
{
	if (g_speeded[id] == 1)
	{
		set_user_maxspeed(id , g_fastspeed); 
	}
	else
	{
		set_user_maxspeed(id , g_normspeed); 
	}
    	return PLUGIN_HANDLED;
} 

public roundStart()
{
	for (new i = 1; i <= g_maxplayers; i++)
	{
		i_cooldown_time[i] = floatround(g_abilonecooldown)
		g_abil_one_used[i] = 0
		g_speeded[i] = 0
		remove_task(i)
		client_cmd(i,"cl_forwardspeed 300")
		client_cmd(i,"cl_backspeed 300")
	}
}

public ShowHUD(id)
{
	if(is_user_alive(id))
	{
		i_cooldown_time[id] = i_cooldown_time[id] - 1;
		set_hudmessage(200, 100, 0,  0.80, 0.87, 0, 1.0, 1.1, 0.0, 0.0, -1)
		show_hudmessage(id, "[Способность через : %d]",i_cooldown_time[id])
	}else{
		remove_task(id)
	}
}

public use_ability_one(id)
{
	if (is_user_alive(id) && (zp_get_user_zombie_class(id) == g_zclass_china) && zp_get_user_zombie(id) && !zp_get_user_nemesis(id))
	{
		
		if(g_abil_one_used[id] == 0)
		{
			fm_set_rendering(id, kRenderFxGlowShell, 170, 0, 0, kRenderNormal, 0)

			client_cmd(id,"cl_forwardspeed 1000")
			client_cmd(id,"cl_backspeed 1000")
	
			message_begin (MSG_BROADCAST,SVC_TEMPENTITY)
			write_byte (TE_BEAMFOLLOW)
			write_short (id)
			write_short (gTrail)
			write_byte (TRAIL_LIFE)
			write_byte (TRAIL_WIDTH)
			write_byte (TRAIL_RED)
			write_byte (TRAIL_GREEN)
			write_byte (TRAIL_BLUE)
			write_byte (TRAIL_BRIGTHNESS)
			message_end()

			red_screen(id)
			g_speeded[id] = 1
			emit_sound(id, CHAN_STREAM, sound_china_sprint, 1.0, ATTN_NORM, 0, PITCH_NORM)
			g_abil_one_used[id] = 1
			set_task(g_abilonelenght, "set_normal_speed", id)
						
			i_cooldown_time[id] = floatround(g_abilonecooldown)
			set_task(1.0, "ShowHUD", id, _, _, "a",i_cooldown_time[id])
//			client_print(id,print_chat,"[dev] - use ability")
		}		
	}
}

public set_normal_speed(id)
{
	if ((zp_get_user_zombie_class(id) == g_zclass_china) && zp_get_user_zombie(id) && !zp_get_user_nemesis(id))
	{
		g_speeded[id] = 0
		client_cmd(id,"cl_forwardspeed 300")
		client_cmd(id,"cl_backspeed 300")
		set_task(g_abilonecooldown,"set_ability_one_cooldown",id)
	}
}

red_screen(const id, const iFade = 1)
{ 
	message_begin(MSG_ONE,get_user_msgid("ScreenFade"),_,id)
	write_short(8192 * iFade)
	write_short(8192 * iFade)
	write_short(0x0000)
	write_byte(255)
	write_byte(0)
	write_byte(0)
	write_byte(125)
	message_end()
}

public set_ability_one_cooldown(id)
{
	if ((zp_get_user_zombie_class(id) == g_zclass_china) && zp_get_user_zombie(id) && !zp_get_user_nemesis(id))
	{
		g_abil_one_used[id] = 0
		new text[100]
		format(text,99,"^x04[ZP] ^x01Способность готова!!!")
		message_begin(MSG_ONE,get_user_msgid("SayText"),{0,0,0},id) 
		write_byte(id) 
		write_string(text) 
		message_end()
	}
}

public zp_user_infected_post(id, infector)
{
	if ((zp_get_user_zombie_class(id) == g_zclass_china) && !zp_get_user_nemesis(id))
	{
		emit_sound(id, CHAN_VOICE, g_china_Infect_Sound[random(sizeof g_china_Infect_Sound)],  VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		new text[100]
		new note_cooldown = floatround(g_abilonecooldown)
		format(text,99,"^x04[ZP] ^x01Способность^x04 [Разгон] ^x01 | Время:^x04 %d ^x01сек.",note_cooldown)
		message_begin(MSG_ONE,get_user_msgid("SayText"),{0,0,0},id) 
		write_byte(id) 
		write_string(text) 
		message_end()
		
		i_cooldown_time[id] = floatround(g_abilonecooldown)
		remove_task(id)
		g_speeded[id] = 0
		g_abil_one_used[id] = 0
	}
}

public zp_user_humanized_post(id)
{
	remove_task(id)
	client_cmd(id,"cl_forwardspeed 300")
	client_cmd(id,"cl_backspeed 300")
}


public Event_CurrentWeapon(id)
{
	new weaponID = read_data(2)
	
	if (weaponID == CSW_SMOKEGRENADE)
    
	if(zp_get_user_zombie(id) && zp_get_user_zombie_class(id) == g_zclass_china && !zp_get_user_nemesis(id))
	{
		entity_set_string(id, EV_SZ_viewmodel, KNOCKBOMB_CHINA)
	}

	if (weaponID == CSW_FLASHBANG)
    
	if(zp_get_user_zombie(id) && zp_get_user_zombie_class(id) == g_zclass_china && !zp_get_user_nemesis(id))
	{
		entity_set_string(id, EV_SZ_viewmodel, KNOCKBOMB_CHINA)
	}

}

public CPlayer__TakeDamage(id, iVictim, iInflictor, iAttacker, Float:flDamage, bitsDamage)
{
	if (zp_get_user_zombie_class(id) == g_zclass_china && zp_get_user_zombie(id) && !zp_get_user_nemesis(id) && !zp_get_user_survivor(id))
	{
		new rand = random_num(1,2)
		switch(rand)
  		{
			case 1: emit_sound(id, CHAN_WEAPON, pain_china_sound[0], 1.0, ATTN_NORM, 0, PITCH_LOW)
			case 2: emit_sound(id, CHAN_WEAPON, pain_china_sound2[0], 1.0, ATTN_NORM, 0, PITCH_LOW)
		}
	}
} 

public fw_EmitSound(id, channel, const sample[], Float:volume, Float:attn, flags, pitch)
{
	if(!is_user_connected(id))
		return FMRES_HANDLED;	

	if (sample[0] == 'h' && sample[1] == 'o' && sample[2] == 's' && sample[3] == 't' && sample[4] == 'a' && sample[5] == 'g' && sample[6] == 'e')
		return FMRES_SUPERCEDE;


	if(zp_get_user_zombie(id) && zp_get_user_zombie_class(id) == g_zclass_china && !zp_get_user_nemesis(id))
	{
		if (sample[7] == 'd' && ((sample[8] == 'i' && sample[9] == 'e') || (sample[8] == 'e' && sample[9] == 'a')))
		{
		emit_sound(id, CHAN_WEAPON, death_china_sound[0], 1.0, ATTN_NORM, 0, PITCH_LOW)
		}
	}
	return FMRES_IGNORED;
}
